
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(5, lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name=["bowls_of_cereal", "oranges", "sashimi", "blueberry_pies", "bagged_salads"])


    # Set objective function
    m.setObjective(2*x[0] + 2*x[1] + 6*x[2] + 8*x[3] + 3*x[4], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7.93*x[0] + 13.58*x[1] + 1.23*x[2] + 13.16*x[3] + 14.37*x[4] <= 307, "dollar_cost")
    m.addConstr(4.61*x[0] + 7.9*x[1] + 9.97*x[2] + 13.49*x[3] + 10.58*x[4] <= 345, "tastiness_rating")
    m.addConstr(1.23*x[2] + 13.16*x[3] >= 52, "c1")
    m.addConstr(7.93*x[0] + 1.23*x[2] >= 28, "c2")
    m.addConstr(13.16*x[3] + 14.37*x[4] >= 38, "c3")
    m.addConstr(13.58*x[1] + 14.37*x[4] >= 49, "c4")
    m.addConstr(7.93*x[0] + 13.58*x[1] + 1.23*x[2] >= 59, "c5")
    m.addConstr(7.93*x[0] + 1.23*x[2] + 14.37*x[4] >= 59, "c6")
    m.addConstr(7.93*x[0] + 13.58*x[1] + 1.23*x[2] >= 31, "c7")
    m.addConstr(7.93*x[0] + 1.23*x[2] + 14.37*x[4] >= 31, "c8")
    m.addConstr(7.93*x[0] + 13.58*x[1] + 1.23*x[2] + 13.16*x[3] + 14.37*x[4] >= 31, "c9")
    m.addConstr(4.61*x[0] + 13.49*x[3] >= 31, "c10")
    m.addConstr(4.61*x[0] + 7.9*x[1] >= 36, "c11")
    m.addConstr(7.9*x[1] + 13.49*x[3] >= 44, "c12")
    m.addConstr(9.97*x[2] + 13.49*x[3] >= 68, "c13")
    m.addConstr(7.9*x[1] + 9.97*x[2] >= 63, "c14")
    m.addConstr(7.9*x[1] + 10.58*x[4] >= 41, "c15")
    m.addConstr(9.97*x[2] + 10.58*x[4] >= 43, "c16")
    m.addConstr(4.61*x[0] + 10.58*x[4] >= 52, "c17")
    m.addConstr(7.9*x[1] + 9.97*x[2] + 10.58*x[4] >= 47, "c18")
    m.addConstr(4.61*x[0] + 7.9*x[1] + 9.97*x[2] + 13.49*x[3] + 10.58*x[4] >= 47, "c19")
    m.addConstr(-9*x[1] + 6*x[4] >= 0, "c20")
    m.addConstr(7.93*x[0] + 13.58*x[1] + 14.37*x[4] <= 125, "c21")
    m.addConstr(1.23*x[2] + 13.16*x[3] + 14.37*x[4] <= 156, "c22")
    m.addConstr(13.58*x[1] + 1.23*x[2] + 13.16*x[3] <= 201, "c23")
    m.addConstr(13.58*x[1] + 1.23*x[2] + 14.37*x[4] <= 122, "c24")
    m.addConstr(7.93*x[0] + 13.58*x[1] + 1.23*x[2] <= 199, "c25")
    m.addConstr(7.93*x[0] + 1.23*x[2] + 14.37*x[4] <= 110, "c26")
    m.addConstr(7.93*x[0] + 13.16*x[3] + 14.37*x[4] <= 269, "c27")
    m.addConstr(7.93*x[0] + 13.58*x[1] + 13.16*x[3] <= 158, "c28")
    m.addConstr(4.61*x[0] + 9.97*x[2] + 13.49*x[3] <= 225, "c29")
    m.addConstr(4.61*x[0] + 7.9*x[1] + 10.58*x[4] <= 170, "c30")
    m.addConstr(4.61*x[0] + 7.9*x[1] + 9.97*x[2] <= 88, "c31")
    m.addConstr(4.61*x[0] + 13.49*x[3] + 10.58*x[4] <= 105, "c32")
    m.addConstr(7.9*x[1] + 9.97*x[2] + 10.58*x[4] <= 138, "c33")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
