
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="bowls_of_cereal", lb=0)
x1 = m.addVar(name="oranges", lb=0)
x2 = m.addVar(name="sashimi", lb=0)
x3 = m.addVar(name="blueberry_pies", lb=0)
x4 = m.addVar(name="bagged_salads", lb=0)

# Define the objective function
m.setObjective(2*x0 + 2*x1 + 6*x2 + 8*x3 + 3*x4, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(7.93*x0 <= 307)
m.addConstr(4.61*x0 <= 345)
m.addConstr(13.58*x1 <= 307)
m.addConstr(7.9*x1 <= 345)
m.addConstr(1.23*x2 <= 307)
m.addConstr(9.97*x2 <= 345)
m.addConstr(13.16*x3 <= 307)
m.addConstr(13.49*x3 <= 345)
m.addConstr(14.37*x4 <= 307)
m.addConstr(10.58*x4 <= 345)
m.addConstr(1.23*x2 + 13.16*x3 >= 52)
m.addConstr(7.93*x0 + 1.23*x2 >= 28)
m.addConstr(13.16*x3 + 14.37*x4 >= 38)
m.addConstr(13.58*x1 + 14.37*x4 >= 49)
m.addConstr(7.93*x0 + 13.58*x1 + 1.23*x2 >= 59)
m.addConstr(7.93*x0 + 1.23*x2 + 14.37*x4 >= 59)
m.addConstr(7.93*x0 + 13.58*x1 + 1.23*x2 >= 31)
m.addConstr(7.93*x0 + 1.23*x2 + 14.37*x4 >= 31)
m.addConstr(7.93*x0 + 13.58*x1 + 1.23*x2 + 13.16*x3 + 14.37*x4 >= 31)
m.addConstr(4.61*x0 + 13.49*x3 >= 31)
m.addConstr(4.61*x0 + 7.9*x1 >= 36)
m.addConstr(7.9*x1 + 13.49*x3 >= 44)
m.addConstr(9.97*x2 + 13.49*x3 >= 68)
m.addConstr(7.9*x1 + 9.97*x2 >= 63)
m.addConstr(7.9*x1 + 10.58*x4 >= 41)
m.addConstr(9.97*x2 + 10.58*x4 >= 43)
m.addConstr(4.61*x0 + 10.58*x4 >= 52)
m.addConstr(7.9*x1 + 9.97*x2 + 10.58*x4 >= 47)
m.addConstr(4.61*x0 + 7.9*x1 + 9.97*x2 + 13.49*x3 + 10.58*x4 >= 47)
m.addConstr(-9*x1 + 6*x4 >= 0)
m.addConstr(7.93*x0 + 13.58*x1 + 14.37*x4 <= 125)
m.addConstr(1.23*x2 + 13.16*x3 + 14.37*x4 <= 156)
m.addConstr(13.58*x1 + 1.23*x2 + 13.16*x3 <= 201)
m.addConstr(13.58*x1 + 1.23*x2 + 14.37*x4 <= 122)
m.addConstr(7.93*x0 + 13.58*x1 + 1.23*x2 <= 199)
m.addConstr(7.93*x0 + 1.23*x2 + 14.37*x4 <= 110)
m.addConstr(7.93*x0 + 13.16*x3 + 14.37*x4 <= 269)
m.addConstr(7.93*x0 + 13.58*x1 + 13.16*x3 <= 158)
m.addConstr(4.61*x0 + 9.97*x2 + 13.49*x3 <= 225)
m.addConstr(4.61*x0 + 7.9*x1 + 10.58*x4 <= 170)
m.addConstr(4.61*x0 + 7.9*x1 + 9.97*x2 <= 88)
m.addConstr(4.61*x0 + 13.49*x3 + 10.58*x4 <= 105)
m.addConstr(7.9*x1 + 9.97*x2 + 10.58*x4 <= 138)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bowls of cereal: ", x0.x)
    print("oranges: ", x1.x)
    print("sashimi: ", x2.x)
    print("blueberry pies: ", x3.x)
    print("bagged salads: ", x4.x)
else:
    print("The model is infeasible")
