
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_work_hours")

    # Create variables
    laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
    bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
    mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")


    # Set objective function
    m.setObjective(6 * laura_hours + 7 * bill_hours + 3 * mary_hours, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(13 * laura_hours + 15 * bill_hours >= 20, "c1")
    m.addConstr(13 * laura_hours + 15 * bill_hours + 16 * mary_hours >= 20, "c2")
    m.addConstr(1 * laura_hours + 11 * mary_hours >= 34, "c3")
    m.addConstr(1 * laura_hours + 3 * bill_hours >= 37, "c4")
    m.addConstr(1 * laura_hours + 3 * bill_hours + 11 * mary_hours >= 37, "c5")
    m.addConstr(15 * bill_hours + 16 * mary_hours <= 47, "c6")
    m.addConstr(1 * laura_hours + 3 * bill_hours + 11 * mary_hours <= 134, "c7")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('Bill Hours: %g' % bill_hours.x)
        print('Mary Hours: %g' % mary_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
