
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Laura
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bill
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Mary

    # Define the objective function
    model.setObjective(6 * x0 + 7 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(13 * x0 + 15 * x1 >= 20)
    model.addConstr(13 * x0 + 15 * x1 + 16 * x2 >= 20)
    model.addConstr(x0 + 11 * x2 >= 34)
    model.addConstr(x0 + 3 * x1 >= 37)
    model.addConstr(x0 + 3 * x1 + 11 * x2 >= 37)
    model.addConstr(15 * x1 + 16 * x2 <= 47)
    model.addConstr(x0 + 3 * x1 + 11 * x2 <= 134)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Bill: ", x1.varValue)
        print("Hours worked by Mary: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
