
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x = m.addVars(3, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Bobby", "Mary", "George"])


    # Set objective function
    m.setObjective(5.96 * x[0] + 7.76 * x[1] + 5.99 * x[2], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8 * x[1] + 5 * x[2] >= 15, "c1")
    m.addConstr(8 * x[0] + 5 * x[1] >= 22, "c2")
    m.addConstr(8 * x[0] + 5 * x[1] <= 75, "c3")
    m.addConstr(8 * x[0] + 2 * x[2] <= 61, "c4")
    m.addConstr(8 * x[0] + 5 * x[1] + 2 * x[2] <= 61, "c5")
    m.addConstr(8 * x[0] + 3 * x[2] <= 102, "c6")
    m.addConstr(8 * x[0] + 3 * x[1] <= 134, "c7")
    m.addConstr(8 * x[0] + 3 * x[1] + 3 * x[2] <= 158, "c8")
    m.addConstr(1 * x[1] + 7 * x[2] <= 35, "c9")
    m.addConstr(2 * x[0] + 1 * x[1] <= 48, "c10")
    m.addConstr(2 * x[0] + 1 * x[1] + 7 * x[2] <= 48, "c11")
    m.addConstr(8 * x[1] + 8 * x[2] <= 69, "c12")
    m.addConstr(6 * x[0] + 8 * x[2] <= 50, "c13")
    m.addConstr(6 * x[0] + 8 * x[1] + 8 * x[2] <= 84, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
