
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bobby", lb=0)
x1 = m.addVar(name="hours_worked_by_Mary", lb=0)
x2 = m.addVar(name="hours_worked_by_George", lb=0)

# Define the objective function
m.setObjective(5.96*x0 + 7.76*x1 + 5.99*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x0 <= 85)
m.addConstr(8*x0 <= 170)
m.addConstr(2*x0 <= 87)
m.addConstr(6*x0 <= 87)

m.addConstr(5*x1 <= 85)
m.addConstr(3*x1 <= 170)
m.addConstr(x1 <= 87)
m.addConstr(8*x1 <= 87)

m.addConstr(2*x2 <= 85)
m.addConstr(3*x2 <= 170)
m.addConstr(7*x2 <= 87)
m.addConstr(8*x2 <= 87)

m.addConstr(5*x1 + 2*x2 >= 15)
m.addConstr(8*x0 + 5*x1 >= 22)
m.addConstr(8*x0 + 5*x1 <= 75)
m.addConstr(8*x0 + 2*x2 <= 61)
m.addConstr(8*x0 + 5*x1 + 2*x2 <= 61)
m.addConstr(8*x0 + 3*x2 <= 102)
m.addConstr(8*x0 + 3*x1 <= 134)
m.addConstr(8*x0 + 3*x1 + 3*x2 <= 158)

m.addConstr(x1 + 7*x2 <= 35)
m.addConstr(2*x0 + x1 <= 48)
m.addConstr(2*x0 + x1 + 7*x2 <= 48)

m.addConstr(8*x1 + 8*x2 <= 69)
m.addConstr(6*x0 + 8*x2 <= 50)
m.addConstr(6*x0 + 8*x1 + 8*x2 <= 84)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bobby: ", x0.varValue)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by George: ", x2.varValue)
else:
    print("The model is infeasible.")
