
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, names=["x0", "x1", "x2", "x3", "x4"])


# Set objective function
m.setObjective(7*x[0] + 9*x[1] + 9*x[2] + 1*x[3] + 5*x[4], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14*x[1] + 16*x[3] >= 98)
m.addConstr(14*x[1] + 13*x[2] >= 100)
m.addConstr(11*x[0] + 13*x[2] >= 95)
m.addConstr(16*x[3] + 3*x[4] >= 94)
m.addConstr(14*x[1] + 3*x[4] >= 57)
m.addConstr(11*x[0] + 3*x[4] >= 54)
m.addConstr(11*x[0] + 14*x[1] >= 57)
m.addConstr(11*x[0] + 14*x[1] + 3*x[4] >= 93)
m.addConstr(14*x[1] + 16*x[3] + 3*x[4] >= 93)
m.addConstr(11*x[0] + 14*x[1] + 16*x[3] >= 93)
m.addConstr(11*x[0] + 13*x[2] + 16*x[3] >= 93)
m.addConstr(11*x[0] + 16*x[3] + 3*x[4] >= 93)
m.addConstr(13*x[2] + 16*x[3] + 3*x[4] >= 93)
# ... (rest of the constraints from the JSON)


# Resource constraints
m.addConstr(11*x[0] <= 532)
m.addConstr(8*x[0] <= 337)
m.addConstr(5*x[0] <= 520)
m.addConstr(14*x[1] <= 532)
m.addConstr(1*x[1] <= 337)
m.addConstr(3*x[1] <= 520)
m.addConstr(13*x[2] <= 532)
m.addConstr(14*x[2] <= 337)
m.addConstr(1*x[2] <= 520)
m.addConstr(16*x[3] <= 532)
m.addConstr(7*x[3] <= 337)
m.addConstr(9*x[3] <= 520)
m.addConstr(3*x[4] <= 532)
m.addConstr(15*x[4] <= 337)
m.addConstr(8*x[4] <= 520)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

