
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    ringo_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo_hours")
    bill_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bill_hours")


    # Set objective function
    model.setObjective(3.3 * ringo_hours + 8.28 * bill_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18 * ringo_hours + 3 * bill_hours >= 38, "paperwork_min")
    model.addConstr(32 * ringo_hours + 18 * bill_hours >= 45, "productivity_min")
    model.addConstr(9 * ringo_hours - 2 * bill_hours >= 0, "ringo_bill_relation")
    model.addConstr(18 * ringo_hours + 3 * bill_hours <= 62, "paperwork_max")
    model.addConstr(32 * ringo_hours + 18 * bill_hours <= 84, "productivity_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == gp.GRB.OPTIMAL:
        print("Optimal solution found:")
        print(f"Hours worked by Ringo: {ringo_hours.x}")
        print(f"Hours worked by Bill: {bill_hours.x}")
        print(f"Objective value: {model.objVal}")
    else:
        print(f"Optimization terminated with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
