
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Set the objective function
m.setObjective(3.3*x1 + 8.28*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(18*x1 + 3*x2 >= 38, "paperwork_competence_min")
m.addConstr(32*x1 + 18*x2 >= 45, "productivity_rating_min")
m.addConstr(9*x1 - 2*x2 >= 0, "additional_constraint")
m.addConstr(18*x1 + 3*x2 <= 62, "paperwork_competence_max")
m.addConstr(32*x1 + 18*x2 <= 84, "productivity_rating_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
