
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="hours_worked_by_Ringo", lb=0)  
x2 = model.addVar(name="hours_worked_by_Bill", lb=0, integrality=gurobi.GRB.INTEGER)  

# Define the objective function
model.setObjective(3.3 * x1 + 8.28 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(18 * x1 + 3 * x2 >= 38, name="paperwork_competence_rating")
model.addConstr(32 * x1 + 18 * x2 >= 45, name="productivity_rating")
model.addConstr(9 * x1 - 2 * x2 >= 0, name="productivity_vs_paperwork")
model.addConstr(18 * x1 + 3 * x2 <= 62, name="max_paperwork_competence_rating")
model.addConstr(32 * x1 + 18 * x2 <= 84, name="max_productivity_rating")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Ringo: {x1.varValue}")
    print(f"Hours worked by Bill: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
