
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_magnesium")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B4")


    # Set objective function
    m.setObjective(1.2*x0**2 + 6.74*x0*x1 + 5.86*x0 + 9.51*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 13*x1 >= 48, "digestive_support_lower_bound")
    m.addConstr(6*x0 + 13*x1 <= 96, "digestive_support_upper_bound")
    m.addConstr(15*x0 + 6*x1 >= 24, "muscle_growth_lower_bound")
    m.addConstr(15*x0 + 6*x1 <= 30, "muscle_growth_upper_bound")
    m.addConstr(-6*x0 + 8*x1 >= 0, "constraint_5")
    m.addConstr(6 * x0 <= 147, "digestive_support_mg_upper_bound")
    m.addConstr(15 * x0 <= 57, "muscle_growth_mg_upper_bound")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('milligrams_of_magnesium:', x0.x)
        print('milligrams_of_vitamin_B4:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
