
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams of magnesium", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams of vitamin B4", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(1.2*x1**2 + 6.74*x1*x2 + 5.86*x1 + 9.51*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6*x1 <= 147)
    model.addConstr(15*x1 <= 57)
    model.addConstr(13*x2 <= 147)
    model.addConstr(6*x2 <= 57)
    model.addConstr(6*x1**2 + 13*x2**2 >= 48)
    model.addConstr(6*x1 + 13*x2 >= 48)
    model.addConstr(15*x1**2 + 6*x2**2 >= 24)
    model.addConstr(15*x1 + 6*x2 >= 24)
    model.addConstr(-6*x1 + 8*x2 >= 0)
    model.addConstr(6*x1 + 13*x2 <= 96)
    model.addConstr(15*x1 + 6*x2 <= 30)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of magnesium: {x1.varValue}")
        print(f"Milligrams of vitamin B4: {x2.varValue}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

optimize_problem()
