
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken_breasts")
bowls_of_cereal = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls_of_cereal")
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")

# Set objective function
m.setObjective(7*oranges + 5*chicken_breasts + 9*bowls_of_cereal + 7*strawberries, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6*chicken_breasts + 5*strawberries >= 17, "c1")
m.addConstr(oranges + 6*chicken_breasts >= 27, "c2")
m.addConstr(oranges + 6*chicken_breasts + 5*bowls_of_cereal + 5*strawberries >= 27, "c3")
m.addConstr(2*chicken_breasts + 6*strawberries >= 53, "c4")
m.addConstr(5*oranges + 6*strawberries >= 44, "c5")
m.addConstr(5*oranges + 6*bowls_of_cereal >= 39, "c6")
m.addConstr(2*chicken_breasts + 6*bowls_of_cereal >= 25, "c7")
m.addConstr(5*oranges + 2*chicken_breasts + 6*bowls_of_cereal + 6*strawberries >= 25, "c8")
m.addConstr(chicken_breasts + 4*bowls_of_cereal >= 16, "c9")
m.addConstr(4*bowls_of_cereal + 2*strawberries >= 15, "c10")
m.addConstr(chicken_breasts + 2*strawberries >= 23, "c11")
m.addConstr(9*oranges + chicken_breasts + 4*bowls_of_cereal + 2*strawberries >= 23, "c12")
m.addConstr(-7*chicken_breasts + 4*strawberries >= 0, "c13")
m.addConstr(2*bowls_of_cereal - 5*strawberries >= 0, "c14")
m.addConstr(oranges + 6*chicken_breasts + 5*strawberries <= 142, "c15")
m.addConstr(oranges + 6*chicken_breasts + 5*bowls_of_cereal <= 140, "c16")
m.addConstr(5*oranges + 2*chicken_breasts + 6*bowls_of_cereal <= 187, "c17")
m.addConstr(5*oranges + 6*bowls_of_cereal + 6*strawberries <= 98, "c18")
m.addConstr(4*bowls_of_cereal + 2*strawberries <= 101, "c19")
m.addConstr(9*oranges + chicken_breasts + 2*strawberries <= 48, "c20")

# Resource Constraints
m.addConstr(oranges + 6*chicken_breasts + 5*bowls_of_cereal + 5*strawberries <= 164, "carbohydrates")
m.addConstr(5*oranges + 2*chicken_breasts + 6*bowls_of_cereal + 6*strawberries <= 231, "calcium")
m.addConstr(9*oranges + chicken_breasts + 4*bowls_of_cereal + 2*strawberries <= 183, "healthiness")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

