
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(lb=0, name="oranges", vtype=gurobi.GRB.CONTINUOUS)
x1 = model.addVar(lb=0, name="chicken breasts", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(lb=0, name="bowls of cereal", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(lb=0, name="strawberries", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(7*x0 + 5*x1 + 9*x2 + 7*x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(x0 + 6*x1 + 5*x2 + 5*x3 <= 164)
model.addConstr(5*x0 + 2*x1 + 6*x2 + 6*x3 <= 231)
model.addConstr(9*x0 + x1 + 4*x2 + 2*x3 <= 183)
model.addConstr(6*x1 + 5*x3 >= 17)
model.addConstr(x0 + 6*x1 >= 27)
model.addConstr(x0 + 6*x1 + 5*x2 + 5*x3 >= 27)
model.addConstr(2*x1 + 6*x3 >= 53)
model.addConstr(5*x0 + 6*x3 >= 44)
model.addConstr(5*x0 + 6*x2 >= 39)
model.addConstr(2*x1 + 6*x2 >= 25)
model.addConstr(5*x0 + 2*x1 + 6*x2 + 6*x3 >= 25)
model.addConstr(x1 + 4*x2 >= 16)
model.addConstr(4*x2 + 2*x3 >= 15)
model.addConstr(x1 + 2*x3 >= 23)
model.addConstr(9*x0 + x1 + 4*x2 + 2*x3 >= 23)
model.addConstr(-7*x1 + 4*x3 >= 0)
model.addConstr(2*x2 - 5*x3 >= 0)
model.addConstr(x0 + 6*x1 + 5*x3 <= 142)
model.addConstr(x0 + 6*x1 + 5*x2 <= 140)
model.addConstr(5*x0 + 2*x1 + 6*x2 + 6*x3 <= 187)
model.addConstr(5*x0 + 6*x2 + 6*x3 <= 98)
model.addConstr(4*x2 + 2*x3 <= 101)
model.addConstr(9*x0 + x1 + 2*x3 <= 48)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("oranges: ", x0.varValue)
    print("chicken breasts: ", x1.varValue)
    print("bowls of cereal: ", x2.varValue)
    print("strawberries: ", x3.varValue)
else:
    print("The model is infeasible")
