
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x4")
x5 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x5")


# Set objective
m.setObjective(1.59*x0**2 + 8.97*x0*x1 + 5.63*x0*x3 + 4.13*x0*x4 + 8.22*x0*x5 + 3.11*x1**2 + 1.23*x1*x3 + 7.9*x1*x4 + 9.74*x1*x5 + 1.73*x2**2 + 6.28*x2*x4 + 2.69*x2*x5 + 1.51*x3**2 + 3.12*x3*x4 + 4.55*x4**2 + 4.92*x0 + 9.17*x1 + 2.21*x5, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x0 + 6*x1 + 9*x2 + 6*x3 + 5*x4 + 3*x5 <= 135)
m.addConstr(11*x0 + 4*x1 + 7*x2 + 1*x3 + 4*x4 + 10*x5 <= 148)
m.addConstr(4*x0 + 11*x1 + 10*x2 + 3*x3 + 5*x4 + 2*x5 <= 238)
m.addConstr(6*x3 + 5*x4 >= 19)
m.addConstr(7*x0 + 9*x2 >= 13)
m.addConstr(6*x1**2 + 5*x4**2 >= 9)
m.addConstr(7*x0 + 5*x4 >= 20)
m.addConstr(9*x2**2 + 3*x5**2 >= 17)
m.addConstr(7*x0 + 3*x5 >= 20)
m.addConstr(9*x2 + 5*x4 >= 7)
m.addConstr(7*x0 + 9*x2 + 5*x4 >= 15)
m.addConstr(7*x0 + 6*x1 + 3*x5 >= 15)
m.addConstr(6*x1 + 9*x2 + 6*x3 >= 15)
m.addConstr(7*x0 + 9*x2 + 5*x4 >= 12)
m.addConstr(7*x0**2 + 6*x1**2 + 3*x5**2 >= 12)
m.addConstr(6*x1 + 9*x2 + 6*x3 >= 12)
m.addConstr(7*x0**2 + 9*x2**2 + 5*x4**2 >= 20)
m.addConstr(7*x0 + 6*x1 + 3*x5 >= 20)
m.addConstr(6*x1 + 9*x2 + 6*x3 >= 20)
m.addConstr(7*x0 + 6*x1 + 9*x2 + 6*x3 + 5*x4 + 3*x5 >= 20)
m.addConstr(4*x1**2 + 7*x2**2 >= 14)
m.addConstr(11*x0 + 4*x1 + 4*x4 >= 13)
m.addConstr(11*x0 + 7*x2 + 10*x5 >= 13)
m.addConstr(11*x0 + 1*x3 + 4*x4 >= 13)
m.addConstr(11*x0**2 + 4*x1**2 + 4*x4**2 >= 14)
m.addConstr(11*x0 + 7*x2 + 10*x5 >= 14)
m.addConstr(11*x0 + 1*x3 + 4*x4 >= 14)
m.addConstr(11*x0**2 + 4*x1**2 + 4*x4**2 >= 13)
m.addConstr(11*x0**2 + 7*x2**2 + 10*x5**2 >= 13)
m.addConstr(11*x0 + 1*x3 + 4*x4 >= 13)
m.addConstr(11*x0 + 4*x1 + 7*x2 + 1*x3 + 4*x4 + 10*x5 >= 13)
m.addConstr(10*x2 + 2*x5 >= 28)
m.addConstr(4*x0**2 + 11*x1**2 >= 32)
m.addConstr(4*x0 + 3*x3 >= 30)
m.addConstr(11*x1**2 + 5*x4**2 >= 20)
m.addConstr(5*x4**2 + 2*x5**2 >= 19)
m.addConstr(11*x1 + 10*x2 >= 36)
m.addConstr(4*x0 + 2*x5 >= 17)
m.addConstr(3*x3 + 2*x5 >= 20)
m.addConstr(4*x0 + 11*x1 + 10*x2 + 3*x3 + 5*x4 + 2*x5 >= 20)
m.addConstr(10*x4 - 7*x5 >= 0)
m.addConstr(7*x0 + 6*x1 + 6*x3 <= 79)
m.addConstr(9*x2**2 + 5*x4**2 + 3*x5**2 <= 115)
m.addConstr(6*x1 + 9*x2 + 5*x4 <= 67)
m.addConstr(6*x1**2 + 5*x4**2 + 3*x5**2 <= 87)
m.addConstr(6*x1 + 6*x3 + 3*x5 <= 60)
m.addConstr(9*x2 + 6*x3 + 3*x5 <= 46)
m.addConstr(7*x0**2 + 9*x2**2 + 5*x4**2 <= 107)
m.addConstr(9*x2 + 6*x3 + 5*x4 <= 70)
m.addConstr(11*x0 + 10*x5 <= 86)
m.addConstr(7*x2**2 + 10*x5**2 <= 118)
m.addConstr(1*x3 + 4*x4 <= 52)
m.addConstr(7*x2**2 + 1*x3**2 <= 65)
m.addConstr(4*x4 + 10*x5 <= 50)
m.addConstr(11*x0**2 + 1*x3**2 <= 135)
m.addConstr(4*x1 + 10*x5 <= 145)
m.addConstr(4*x1 + 4*x4 <= 66)
m.addConstr(4*x1 + 7*x2 + 1*x3 <= 41)
m.addConstr(11*x0**2 + 7*x2**2 + 4*x4**2 <= 98)
m.addConstr(11*x0 + 4*x4 + 10*x5 <= 123)
m.addConstr(11*x0 + 1*x3 + 10*x5 <= 66)
m.addConstr(3*x3 + 5*x4 <= 170)
m.addConstr(4*x0**2 + 10*x2**2 <= 238)
m.addConstr(4*x0 + 2*x5 <= 181)
m.addConstr(11*x1**2 + 10*x2**2 + 3*x3**2 <= 213)
m.addConstr(4*x0**2 + 11*x1**2 + 3*x3**2 <= 119)
m.addConstr(4*x0**2 + 10*x2**2 + 5*x4**2 <= 103)
m.addConstr(3*x3**2 + 5*x4**2 + 2*x5**2 <= 125)
m.addConstr(11*x1 + 3*x3 + 5*x4 <= 105)
m.addConstr(11*x1 + 10*x2 + 2*x5 <= 58)
m.addConstr(4*x0 + 11*x1 + 2*x5 <= 213)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

