
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbohydrates = m.addVar(vtype=gp.GRB.INTEGER, name="carbohydrates")
vitamin_k = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_b12 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
vitamin_b1 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b1")
vitamin_b7 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b7")
vitamin_b9 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
vitamin_c = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_c")


# Set objective
m.setObjective(1.09 * carbohydrates + 1.84 * vitamin_k + 9.7 * iron + 5.2 * vitamin_b12 + 3.89 * vitamin_b1 + 1.97 * vitamin_b7 + 4.5 * vitamin_b9 + 2.81 * vitamin_c, gp.GRB.MINIMIZE)

# Add constraints from resources/attributes
m.addConstr(5.02 * carbohydrates + 23.04 * vitamin_k + 16.85 * iron + 19.3 * vitamin_b12 + 6.39 * vitamin_b1 + 22.9 * vitamin_b7 + 24.37 * vitamin_b9 + 21.59 * vitamin_c >= 43, "cognitive_performance_total")
m.addConstr(24.9 * carbohydrates + 24.07 * vitamin_k + 19.5 * iron + 25.4 * vitamin_b12 + 19.78 * vitamin_b1 + 13.24 * vitamin_b7 + 5.6 * vitamin_b9 + 0.02 * vitamin_c <= 526, "digestive_support_total")

m.addConstr(5.02 * carbohydrates <= 398, "cognitive_performance_carbohydrates")

m.addConstr(23.04 * vitamin_k + 19.3 * vitamin_b12 >= 33, "cognitive_performance_k_b12")
m.addConstr(16.85 * iron + 6.39 * vitamin_b1 >= 26, "cognitive_performance_iron_b1")
m.addConstr(5.02 * carbohydrates + 21.59 * vitamin_c >= 26, "cognitive_performance_carbohydrates_c")
m.addConstr(5.02 * carbohydrates + 24.37 * vitamin_b9 >= 20, "cognitive_performance_carbohydrates_b9")
m.addConstr(5.02 * carbohydrates + 6.39 * vitamin_b1 >= 19, "cognitive_performance_carbohydrates_b1")
m.addConstr(6.39 * vitamin_b1 + 22.9 * vitamin_b7 >= 16, "cognitive_performance_b1_b7")
m.addConstr(23.04 * vitamin_k + 22.9 * vitamin_b7 >= 25, "cognitive_performance_k_b7")
m.addConstr(22.9 * vitamin_b7 + 21.59 * vitamin_c >= 27, "cognitive_performance_b7_c")
m.addConstr(19.3 * vitamin_b12 + 21.59 * vitamin_c >= 43, "cognitive_performance_b12_c")


m.addConstr(24.9 * carbohydrates + 24.07 * vitamin_k >= 44, "digestive_support_carbohydrates_k")
m.addConstr(24.07 * vitamin_k + 19.5 * iron >= 40, "digestive_support_k_iron")
m.addConstr(24.9 * carbohydrates + 19.78 * vitamin_b1 >= 54, "digestive_support_carbohydrates_b1")
m.addConstr(19.78 * vitamin_b1 + 13.24 * vitamin_b7 >= 54, "digestive_support_b1_b7")
m.addConstr(24.07 * vitamin_k + 5.6 * vitamin_b9 >= 37, "digestive_support_k_b9")

m.addConstr(-8 * vitamin_b12 + 2 * vitamin_c >= 0, "constraint_b12_c")
m.addConstr(-9 * carbohydrates + 5 * vitamin_b1 >= 0, "constraint_carbohydrates_b1")
m.addConstr(iron - 4 * vitamin_b12 >= 0, "constraint_iron_b12")


# Optimize model
m.optimize()

# Print solution or infeasibility message
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % m.status)
    # Compute IIS
    m.computeIIS()
    for c in m.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)

