
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")


    # Set objective function
    m.setObjective(7.43 * x0 + 2.24 * x1 + 4.55 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * x0 + 13 * x1 + 24 * x2 >= 53, "c1")
    m.addConstr(8 * x0 + 27 * x2 >= 21, "c2")
    m.addConstr(13 * x1 + 24 * x2 <= 176, "c3")
    m.addConstr(4 * x0 + 13 * x1 + 24 * x2 <= 176, "c4")
    m.addConstr(6 * x1 + 28 * x2 <= 93, "c5")
    m.addConstr(9 * x0 + 6 * x1 <= 210, "c6")
    m.addConstr(9 * x0 + 28 * x2 <= 187, "c7")
    m.addConstr(9 * x0 + 6 * x1 + 28 * x2 <= 187, "c8")
    m.addConstr(8 * x0 + 21 * x1 <= 131, "c9")
    m.addConstr(8 * x0 + 27 * x2 <= 147, "c10")
    m.addConstr(8 * x0 + 21 * x1 + 27 * x2 <= 147, "c11")

    # Resource constraints
    m.addConstr(4 * x0 <= 236, "r0_x0")
    m.addConstr(9 * x0 <= 212, "r1_x0")
    m.addConstr(8 * x0 <= 191, "r2_x0")
    m.addConstr(13 * x1 <= 236, "r0_x1")
    m.addConstr(6 * x1 <= 212, "r1_x1")
    m.addConstr(21 * x1 <= 191, "r2_x1")
    m.addConstr(24 * x2 <= 236, "r0_x2")
    m.addConstr(28 * x2 <= 212, "r1_x2")
    m.addConstr(27 * x2 <= 191, "r2_x2")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
