
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_zinc", lb=0)
    x1 = model.addVar(name="milligrams_of_vitamin_B1", lb=0)
    x2 = model.addVar(name="milligrams_of_calcium", lb=0)

    # Define the objective function
    model.setObjective(7.43 * x0 + 2.24 * x1 + 4.55 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * x0 <= 236)
    model.addConstr(9 * x0 <= 212)
    model.addConstr(8 * x0 <= 191)
    model.addConstr(13 * x1 <= 236)
    model.addConstr(6 * x1 <= 212)
    model.addConstr(21 * x1 <= 191)
    model.addConstr(24 * x2 <= 236)
    model.addConstr(28 * x2 <= 212)
    model.addConstr(27 * x2 <= 191)
    model.addConstr(13 * x1 + 24 * x2 >= 53)
    model.addConstr(8 * x0 + 27 * x2 >= 21)
    model.addConstr(13 * x1 + 24 * x2 <= 176)
    model.addConstr(4 * x0 + 13 * x1 + 24 * x2 <= 176)
    model.addConstr(6 * x1 + 28 * x2 <= 93)
    model.addConstr(9 * x0 + 6 * x1 <= 210)
    model.addConstr(9 * x0 + 28 * x2 <= 187)
    model.addConstr(9 * x0 + 6 * x1 + 28 * x2 <= 187)
    model.addConstr(8 * x0 + 21 * x1 <= 131)
    model.addConstr(8 * x0 + 27 * x2 <= 147)
    model.addConstr(8 * x0 + 21 * x1 + 27 * x2 <= 147)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of zinc: {x0.varValue}")
        print(f"Milligrams of vitamin B1: {x1.varValue}")
        print(f"Milligrams of calcium: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize()
