
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="black_beans")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")


    # Set objective function
    m.setObjective(8*x0 + 6*x1 + 9*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14*x1 + 1*x2 >= 6, "c0")
    m.addConstr(5*x0 + 14*x1 >= 15, "c1")
    m.addConstr(5*x0 + 14*x1 + 1*x2 >= 20, "c2")
    m.addConstr(14*x1 + 14*x2 >= 24, "c3")
    m.addConstr(1*x0 + 14*x1 >= 10, "c4")
    m.addConstr(1*x0 + 14*x1 + 14*x2 >= 10, "c5")
    m.addConstr(5*x0 + 14*x1 <= 45, "c6")
    m.addConstr(14*x1 + 1*x2 <= 58, "c7")
    m.addConstr(1*x0 + 14*x1 + 14*x2 <= 48, "c8")
    m.addConstr(5*x0 + 14*x1 + 1*x2 <= 60, "carbohydrate_limit")
    m.addConstr(1*x0 + 14*x1 + 14*x2 <= 92, "umami_limit")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
