
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="protein_bars", lb=0)  # protein bars
x1 = model.addVar(name="black_beans", lb=0)  # black beans
x2 = model.addVar(name="ham_sandwiches", lb=0)  # ham sandwiches

# Define the objective function
model.setObjective(8 * x0 + 6 * x1 + 9 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * x0 + 14 * x1 + x2 >= 20)  # at least 20 grams of carbohydrates
model.addConstr(14 * x1 + x2 >= 6)  # at least 6 grams of carbohydrates from black beans and ham sandwiches
model.addConstr(5 * x0 + 14 * x1 >= 15)  # at least 15 grams of carbohydrates from protein bars and black beans
model.addConstr(14 * x1 + 14 * x2 >= 24)  # umami index from black beans and ham sandwiches
model.addConstr(x0 + 14 * x1 >= 10)  # umami index from protein bars and black beans
model.addConstr(x0 + 14 * x1 + 14 * x2 >= 10)  # umami index from all sources
model.addConstr(5 * x0 + 14 * x1 <= 45)  # up to 45 grams of carbohydrates from protein bars and black beans
model.addConstr(14 * x1 + x2 <= 58)  # up to 58 grams of carbohydrates from black beans and ham sandwiches
model.addConstr(x0 + 14 * x1 + 14 * x2 <= 48)  # umami index from all sources

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Protein bars: ", x0.varValue)
    print("Black beans: ", x1.varValue)
    print("Ham sandwiches: ", x2.varValue)
else:
    print("The model is infeasible")
