
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of calcium
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B2


    # Set objective function
    m.setObjective(3*x0 + 9*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(18*x0 + 4*x1 >= 66, "c0")
    m.addConstr(22*x0 + 10*x1 >= 41, "c1")
    m.addConstr(20*x0 + 5*x1 >= 61, "c2")
    m.addConstr(16*x0 + 25*x1 >= 43, "c3")
    m.addConstr(3*x0 - 8*x1 >= 0, "c4")
    m.addConstr(18*x0 + 4*x1 <= 133, "c5")
    m.addConstr(22*x0 + 10*x1 <= 68, "c6")
    m.addConstr(20*x0 + 5*x1 <= 95, "c7")
    m.addConstr(16*x0 + 25*x1 <= 222, "c8")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
