
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(name="milligrams_of_calcium", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
x2 = m.addVar(name="milligrams_of_vitamin_B2", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)

# Define the objective function
m.setObjective(3*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(18*x1 + 4*x2 >= 66, name="immune_support_index_min")
m.addConstr(18*x1 + 4*x2 <= 133, name="immune_support_index_max")
m.addConstr(22*x1 + 10*x2 >= 41, name="cognitive_performance_index_min")
m.addConstr(22*x1 + 10*x2 <= 68, name="cognitive_performance_index_max")
m.addConstr(20*x1 + 5*x2 >= 61, name="digestive_support_index_min")
m.addConstr(20*x1 + 5*x2 <= 95, name="digestive_support_index_max")
m.addConstr(16*x1 + 25*x2 >= 43, name="cardiovascular_support_index_min")
m.addConstr(16*x1 + 25*x2 <= 222, name="cardiovascular_support_index_max")
m.addConstr(3*x1 - 8*x2 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of calcium: {x1.x}")
    print(f"Milligrams of vitamin B2: {x2.x}")
else:
    print("No optimal solution found.")
