
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='milligrams_of_calcium', lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name='milligrams_of_vitamin_B2', lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(3*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18*x1 + 4*x2 >= 66, name='immune_support_index_min')
    model.addConstr(22*x1 + 10*x2 >= 41, name='cognitive_performance_index_min')
    model.addConstr(20*x1 + 5*x2 >= 61, name='digestive_support_index_min')
    model.addConstr(16*x1 + 25*x2 >= 43, name='cardiovascular_support_index_min')
    model.addConstr(3*x1 - 8*x2 >= 0, name='calcium_vitamin_B2_ratio_min')
    model.addConstr(18*x1 + 4*x2 <= 133, name='immune_support_index_max')
    model.addConstr(22*x1 + 10*x2 <= 68, name='cognitive_performance_index_max')
    model.addConstr(20*x1 + 5*x2 <= 95, name='digestive_support_index_max')
    model.addConstr(16*x1 + 25*x2 <= 222, name='cardiovascular_support_index_max')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'milligrams of calcium: {x1.varValue}')
        print(f'milligrams of vitamin B2: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
