
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
    carbs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbs")
    protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")

    # Set objective function
    m.setObjective(3*zinc + 3*vitamin_b1 + 5*carbs + 6*protein, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(zinc + 4*vitamin_b1 + 7*carbs + 17*protein <= 270, "immune_support_index_limit")
    m.addConstr(12*zinc + 6*vitamin_b1 + 15*carbs + 17*protein <= 320, "cardiovascular_support_index_limit")

    m.addConstr(zinc + 7*carbs + 17*protein >= 41, "immune_support_1")
    m.addConstr(4*vitamin_b1 + 7*carbs + 17*protein >= 41, "immune_support_2")
    m.addConstr(zinc + 4*vitamin_b1 + 17*protein >= 41, "immune_support_3")
    m.addConstr(zinc + 7*carbs + 17*protein >= 62, "immune_support_4")
    m.addConstr(4*vitamin_b1 + 7*carbs + 17*protein >= 62, "immune_support_5")
    m.addConstr(zinc + 4*vitamin_b1 + 17*protein >= 62, "immune_support_6")


    m.addConstr(6*vitamin_b1 + 17*protein >= 66, "cardio_support_1")
    m.addConstr(12*zinc + 15*carbs >= 79, "cardio_support_2")
    m.addConstr(12*zinc + 17*protein >= 54, "cardio_support_3")
    m.addConstr(15*carbs + 17*protein >= 59, "cardio_support_4")
    m.addConstr(12*zinc + 6*vitamin_b1 >= 72, "cardio_support_5")

    m.addConstr(4*vitamin_b1 + 7*carbs <= 263, "immune_upper_bound_1")
    m.addConstr(zinc + 17*protein <= 90, "immune_upper_bound_2")
    m.addConstr(4*vitamin_b1 + 17*protein <= 118, "immune_upper_bound_3")
    m.addConstr(zinc + 7*carbs <= 127, "immune_upper_bound_4")
    m.addConstr(zinc + 4*vitamin_b1 <= 133, "immune_upper_bound_5")
    m.addConstr(zinc + 4*vitamin_b1 + 17*protein <= 210, "immune_upper_bound_6")
    m.addConstr(zinc + 7*carbs + 17*protein <= 261, "immune_upper_bound_7")
    m.addConstr(zinc + 4*vitamin_b1 + 7*carbs <= 130, "immune_upper_bound_8")
    m.addConstr(zinc + 4*vitamin_b1 + 7*carbs + 17*protein <= 130, "immune_upper_bound_9")

    m.addConstr(12*zinc + 17*protein <= 229, "cardio_upper_bound_1")
    m.addConstr(12*zinc + 6*vitamin_b1 <= 259, "cardio_upper_bound_2")
    m.addConstr(6*vitamin_b1 + 15*carbs <= 254, "cardio_upper_bound_3")
    m.addConstr(12*zinc + 15*carbs <= 225, "cardio_upper_bound_4")
    m.addConstr(15*carbs + 17*protein <= 208, "cardio_upper_bound_5")
    m.addConstr(12*zinc + 6*vitamin_b1 + 15*carbs + 17*protein <= 208, "cardio_upper_bound_6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
