
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="milligrams_of_zinc")
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B1")
x2 = m.addVar(lb=0, name="grams_of_carbohydrates")
x3 = m.addVar(lb=0, name="grams_of_protein")

# Define the objective function
m.setObjective(3*x0 + 3*x1 + 5*x2 + 6*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 + 4*x1 + 7*x2 + 17*x3 >= 41, "Immune_Support_Min")
m.addConstr(x0 + 4*x1 + 7*x2 + 17*x3 <= 130, "Immune_Support_Max")
m.addConstr(12*x0 + 6*x1 + 15*x2 + 17*x3 <= 208, "Cardiovascular_Support_Max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of Zinc:", x0.x)
    print("Milligrams of Vitamin B1:", x1.x)
    print("Grams of Carbohydrates:", x2.x)
    print("Grams of Protein:", x3.x)
else:
    print("No optimal solution found.")

