
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="milligrams of zinc")
    x1 = model.addVar(lb=0, name="milligrams of vitamin B1")
    x2 = model.addVar(lb=0, name="grams of carbohydrates")
    x3 = model.addVar(lb=0, name="grams of protein")

    # Objective function
    model.setObjective(3*x0 + 3*x1 + 5*x2 + 6*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1*x0 + 4*x1 + 7*x2 + 17*x3 >= 41)
    model.addConstr(4*x0 + 1*x1 + 7*x2 + 17*x3 >= 41)
    model.addConstr(1*x0 + 4*x1 + 17*x3 >= 41)
    model.addConstr(1*x0 + 7*x2 + 17*x3 >= 62)
    model.addConstr(4*x1 + 7*x2 + 17*x3 >= 62)
    model.addConstr(12*x0 + 6*x1 + 17*x3 >= 62)
    model.addConstr(12*x0 + 15*x2 + 17*x3 >= 62)
    model.addConstr(4*x1 + 15*x2 + 17*x3 >= 62)
    model.addConstr(12*x0 + 6*x1 + 17*x3 >= 62)
    model.addConstr(12*x0 + 15*x2 >= 79)
    model.addConstr(12*x0 + 17*x3 >= 54)
    model.addConstr(15*x2 + 17*x3 >= 59)
    model.addConstr(12*x0 + 6*x1 >= 72)
    model.addConstr(4*x1 + 7*x2 <= 263)
    model.addConstr(1*x0 + 17*x3 <= 90)
    model.addConstr(4*x1 + 17*x3 <= 118)
    model.addConstr(1*x0 + 7*x2 <= 127)
    model.addConstr(1*x0 + 4*x1 <= 133)
    model.addConstr(1*x0 + 4*x1 + 17*x3 <= 210)
    model.addConstr(1*x0 + 7*x2 + 17*x3 <= 261)
    model.addConstr(1*x0 + 4*x1 + 7*x2 <= 130)
    model.addConstr(1*x0 + 4*x1 + 7*x2 + 17*x3 <= 130)
    model.addConstr(12*x0 + 17*x3 <= 229)
    model.addConstr(12*x0 + 6*x1 <= 259)
    model.addConstr(6*x1 + 15*x2 <= 254)
    model.addConstr(12*x0 + 15*x2 <= 225)
    model.addConstr(15*x2 + 17*x3 <= 208)
    model.addConstr(12*x0 + 6*x1 + 15*x2 + 17*x3 <= 208)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of zinc: {x0.varValue}")
        print(f"Milligrams of vitamin B1: {x1.varValue}")
        print(f"Grams of carbohydrates: {x2.varValue}")
        print(f"Grams of protein: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
