
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B9
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # grams of protein
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # milligrams of vitamin B4
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B1


    # Set objective function
    m.setObjective(7.04*x0 + 9.18*x1 + 9.99*x2 + 2.45*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 9*x1 + 19*x2 + 3*x3 <= 122, "c0")
    m.addConstr(9*x1 + 19*x2 >= 26, "c1")
    m.addConstr(9*x1 + 3*x3 >= 30, "c2")
    m.addConstr(3*x0 + 9*x1 >= 11, "c3")
    m.addConstr(3*x0 + 19*x2 >= 14, "c4")
    m.addConstr(3*x0 + 9*x1 + 19*x2 + 3*x3 >= 14, "c5")
    m.addConstr(-9*x2 + 4*x3 >= 0, "c6")
    m.addConstr(3*x0 - 2*x2 >= 0, "c7")
    m.addConstr(6*x1 - 5*x2 >= 0, "c8")
    m.addConstr(3*x0 + 19*x2 <= 51, "c9")
    m.addConstr(19*x2 + 3*x3 <= 66, "c10")
    m.addConstr(3*x0 + 3*x3 <= 71, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
