
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', vtype='I')  # integer
    x2 = model.addVar(name='x2')  # continuous
    x3 = model.addVar(name='x3', vtype='I')  # integer
    x4 = model.addVar(name='x4')  # continuous

    # Objective function
    model.setObjective(7.04 * x1 + 9.18 * x2 + 9.99 * x3 + 2.45 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 == 3)
    model.addConstr(9 * x2 >= 9)
    model.addConstr(19 * x3 >= 19)
    model.addConstr(3 * x4 >= 3)
    model.addConstr(9 * x2 + 19 * x3 >= 26)
    model.addConstr(9 * x2 + 3 * x4 >= 30)
    model.addConstr(3 * x1 + 9 * x2 >= 11)
    model.addConstr(3 * x1 + 19 * x3 >= 14)
    model.addConstr(3 * x1 + 9 * x2 + 19 * x3 + 3 * x4 >= 14)
    model.addConstr(-9 * x3 + 4 * x4 >= 0)
    model.addConstr(3 * x1 - 2 * x3 >= 0)
    model.addConstr(6 * x2 - 5 * x3 >= 0)
    model.addConstr(3 * x1 + 19 * x3 <= 51)
    model.addConstr(19 * x3 + 3 * x4 <= 66)
    model.addConstr(3 * x1 + 3 * x4 <= 71)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
        print('x4: ', x4.varValue)
    else:
        print('The model is infeasible')

optimize_problem()
