
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")


# Set objective function
m.setObjective(2.15 * x0 + 9.26 * x1 + 8.44 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * x0 + 12 * x1 + 7 * x2 <= 79, "data_integrity_impact")
m.addConstr(14 * x0 + 13 * x1 + 8 * x2 <= 101, "power_consumption")
m.addConstr(9 * x0 + 14 * x1 + 13 * x2 <= 109, "data_accessibility_impact")
m.addConstr(3 * x0 + 7 * x2 >= 14, "data_integrity_impact_x0_x2")
m.addConstr(3 * x0 + 12 * x1 >= 22, "data_integrity_impact_x0_x1")
m.addConstr(3 * x0 + 12 * x1 + 7 * x2 >= 18, "total_data_integrity_impact")
m.addConstr(14 * x0 + 8 * x2 >= 22, "power_consumption_x0_x2")
m.addConstr(14 * x0 + 13 * x1 + 8 * x2 >= 22, "total_power_consumption")
m.addConstr(9 * x0 + 13 * x2 >= 34, "data_accessibility_impact_x0_x2")
m.addConstr(9 * x0 + 14 * x1 >= 30, "data_accessibility_impact_x0_x1")
m.addConstr(9 * x0 + 14 * x1 + 13 * x2 >= 30, "total_data_accessibility_impact")
m.addConstr(2 * x1 - x2 >= 0, "two_times_x1_minus_x2")
m.addConstr(14 * x0 + 13 * x1 <= 52, "power_consumption_x0_x1")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('intrusion_analysts:', x0.x)
    print('security_engineers:', x1.x)
    print('honeypots:', x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

