
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="honeypots", vtype=gurobi.GRB.INTEGER)
    
    # Objective function
    model.setObjective(2.15 * x0 + 9.26 * x1 + 8.44 * x2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(3 * x0 + 12 * x1 + 7 * x2 >= 18)
    model.addConstr(3 * x0 + 12 * x1 >= 22)
    model.addConstr(3 * x0 + 7 * x2 >= 14)
    model.addConstr(14 * x0 + 13 * x1 + 8 * x2 >= 22)
    model.addConstr(14 * x0 + 13 * x1 <= 52)
    model.addConstr(14 * x0 + 8 * x2 >= 22)
    model.addConstr(9 * x0 + 14 * x1 + 13 * x2 >= 30)
    model.addConstr(9 * x0 + 14 * x1 >= 30)
    model.addConstr(2 * x1 - x2 >= 0)
    
    # Optimize
    model.optimize()
    
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Intrusion Analysts: {x0.varValue}")
        print(f"Security Engineers: {x1.varValue}")
        print(f"Honeypots: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
