
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
sashimi = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sashimi")
cantaloupes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cantaloupes")
cornichons = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
black_beans = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")
oreos = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")


# Set objective function
m.setObjective(sashimi**2 + 5*sashimi*cornichons + 9*sashimi*black_beans + 4*sashimi*oreos + 5*cantaloupes*cornichons + 2*cantaloupes*black_beans + 9*cornichons*black_beans + 5*cornichons*oreos + cantaloupes + 2*cornichons, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*sashimi + 19*cornichons >= 43, "c0")
m.addConstr(23*black_beans + 9*oreos >= 29, "c1")
m.addConstr(23*cantaloupes + 2*black_beans <= 76, "c2")
m.addConstr(13*sashimi**2 + 2*black_beans**2 <= 119, "c3")
m.addConstr(2*black_beans**2 + 12*oreos**2 <= 312, "c4")

m.addConstr(13*sashimi + 23*cantaloupes + 19*cornichons + 2*black_beans + 12*oreos <= 369, "calcium_ub")
m.addConstr(26*sashimi + 25*cantaloupes + 24*cornichons + 23*black_beans + 9*oreos <= 348, "fat_ub")

m.addConstr(24*cornichons + 23*black_beans <= 342, "c5")
m.addConstr(25*cantaloupes + 24*cornichons <= 269, "c6")
m.addConstr(25*cantaloupes**2 + 9*oreos**2 <= 206, "c7")
m.addConstr(25*cantaloupes + 23*black_beans <= 328, "c8")
m.addConstr(23*black_beans + 9*oreos <= 88, "c9")
m.addConstr(26*sashimi + 25*cantaloupes <= 76, "c10")
m.addConstr(24*cornichons + 9*oreos <= 213, "c11")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

