
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="sashimi", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="cantaloupes", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="cornichons", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x3 = m.addVar(name="black_beans", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x4 = m.addVar(name="oreos", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Objective function
m.setObjective(x0**2 + 5*x0*x2 + 9*x0*x3 + 4*x0*x4 + 5*x1*x2 + 2*x1*x3 + 9*x2*x3 + 5*x2*x4 + x1 + 2*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(13*x0 + 23*x1 + 19*x2 + 2*x3 + 12*x4 <= 369)
m.addConstr(26*x0 + 25*x1 + 24*x2 + 23*x3 + 9*x4 <= 348)
m.addConstr(13*x0 + 19*x2 >= 43)
m.addConstr(23*x3 + 9*x4 >= 29)
m.addConstr(23*x1 + 2*x3 <= 76)
m.addConstr((13**2)*x0**2 + (2**2)*x3**2 <= 119)
m.addConstr((2**2)*x3**2 + (12**2)*x4**2 <= 312)
m.addConstr(13*x0 + 23*x1 + 19*x2 + 2*x3 + 12*x4 <= 312)
m.addConstr(24*x2 + 23*x3 <= 342)
m.addConstr(25*x1 + 24*x2 <= 269)
m.addConstr((25**2)*x1**2 + (9**2)*x4**2 <= 206)
m.addConstr(25*x1 + 23*x3 <= 328)
m.addConstr(23*x3 + 9*x4 <= 88)
m.addConstr(26*x0 + 25*x1 <= 76)
m.addConstr(24*x2 + 9*x4 <= 213)
m.addConstr(26*x0 + 25*x1 + 24*x2 + 23*x3 + 9*x4 <= 213)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("sashimi: ", x0.varValue)
    print("cantaloupes: ", x1.varValue)
    print("cornichons: ", x2.varValue)
    print("black beans: ", x3.varValue)
    print("oreos: ", x4.varValue)
else:
    print("The model is infeasible")
