
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
    ravioli = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")
    apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")

    # Set objective function
    m.setObjective(9 * kale_salads + 8 * ravioli + 6 * apple_pies, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9 * kale_salads + 17 * ravioli + 2 * apple_pies >= 50, "c0")
    m.addConstr(3 * kale_salads + 7 * ravioli + 20 * apple_pies >= 36, "c1")
    m.addConstr(9 * kale_salads + 17 * ravioli <= 163, "c2")
    m.addConstr(9 * kale_salads + 17 * ravioli + 2 * apple_pies <= 83, "c3")
    m.addConstr(3 * kale_salads + 7 * ravioli <= 90, "c4")
    m.addConstr(7 * ravioli + 20 * apple_pies <= 151, "c5")
    m.addConstr(3 * kale_salads + 20 * apple_pies <= 169, "c6")
    m.addConstr(3 * kale_salads + 7 * ravioli + 20 * apple_pies <= 169, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('kale_salads:', kale_salads.x)
        print('ravioli:', ravioli.x)
        print('apple_pies:', apple_pies.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
