
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='kale_salads', lb=0)  # No upper bound for x0, x1, x2
    x1 = model.addVar(name='ravioli', lb=0)
    x2 = model.addVar(name='apple_pies', lb=0)

    # Define the objective function
    model.setObjective(9 * x0 + 8 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(9 * x0 + 17 * x1 + 2 * x2 >= 50)
    model.addConstr(3 * x0 + 7 * x1 + 20 * x2 >= 36)
    model.addConstr(9 * x0 + 17 * x1 <= 163)
    model.addConstr(9 * x0 + 17 * x1 + 2 * x2 <= 83)
    model.addConstr(3 * x0 + 7 * x1 <= 90)
    model.addConstr(7 * x1 + 20 * x2 <= 151)
    model.addConstr(3 * x0 + 20 * x2 <= 169)
    model.addConstr(3 * x0 + 7 * x1 + 20 * x2 <= 169)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Kale salads: ', x0.varValue)
        print('Ravioli: ', x1.varValue)
        print('Apple pies: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
