
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    kiwis = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")
    chicken_breasts = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")
    granola_bars = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")


    # Set objective function
    m.setObjective(1.28*kiwis**2 + 7.27*kiwis*granola_bars + 7.84*chicken_breasts**2 + 7.73*kiwis + 9.52*chicken_breasts + 2.5*granola_bars, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1.05*kiwis + 17.17*chicken_breasts >= 54, "tastiness_kiwis_chicken")
    m.addConstr(17.17*chicken_breasts + 13.54*granola_bars >= 38, "tastiness_chicken_granola")
    m.addConstr(17.17*chicken_breasts + 13.54*granola_bars <= 170, "tastiness_chicken_granola_upper")
    m.addConstr(1.05*kiwis + 17.17*chicken_breasts + 13.54*granola_bars <= 170, "tastiness_total")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('kiwis:', kiwis.x)
        print('chicken_breasts:', chicken_breasts.x)
        print('granola_bars:', granola_bars.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
