
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="kiwis", lb=-GRB.INFINITY)  # Allows for fractional values
x2 = m.addVar(name="chicken_breasts", lb=-GRB.INFINITY)
x3 = m.addVar(name="granola_bars", lb=-GRB.INFINITY)

# Set the objective function
m.setObjective(1.28*x1**2 + 7.27*x1*x3 + 7.84*x2**2 + 7.73*x1 + 9.52*x2 + 2.5*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.05*x1 + 17.17*x2 >= 54, name="tastiness_kiwis_chicken")
m.addConstr(17.17*x2 + 13.54*x3 >= 38, name="tastiness_chicken_granola")
m.addConstr(17.17*x2 + 13.54*x3 <= 170, name="max_tastiness_chicken_granola")
m.addConstr(1.05*x1 + 17.17*x2 + 13.54*x3 <= 170, name="total_max_tastiness")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found")
