
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="kiwis", lb=0)  # kiwis
x2 = m.addVar(name="chicken breasts", lb=0)  # chicken breasts
x3 = m.addVar(name="granola bars", lb=0)  # granola bars

# Define the objective function
m.setObjective(1.28*x1**2 + 7.27*x1*x3 + 7.84*x2**2 + 7.73*x1 + 9.52*x2 + 2.5*x3, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(1.05*x1 + 17.17*x2 >= 54)
m.addConstr(17.17*x2 + 13.54*x3 >= 38)
m.addConstr(17.17*x2 + 13.54*x3 <= 170)
m.addConstr(1.05*x1 + 17.17*x2 + 13.54*x3 <= 170)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"kiwis: {x1.varValue}")
    print(f"chicken breasts: {x2.varValue}")
    print(f"granola bars: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
