
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("military_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="engineer_platoons")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance_troops")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")


    # Set objective function
    m.setObjective(3*x0 + 7*x1 + 6*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 6*x1 + 1*x2 >= 40, "deployment_weight_min")
    m.addConstr(12*x0 + 14*x2 >= 30, "offensive_capability_eng_cbrn_min")
    m.addConstr(12*x0 + 3*x1 >= 28, "offensive_capability_eng_recon_min")
    m.addConstr(12*x0 + 3*x1 + 14*x2 >= 55, "offensive_capability_total_min")
    m.addConstr(4*x0 + 1*x2 <= 86, "deployment_weight_eng_cbrn_max")
    m.addConstr(4*x0 + 6*x1 <= 89, "deployment_weight_eng_recon_max")
    m.addConstr(4*x0 + 6*x1 + 1*x2 <= 97, "deployment_weight_total_max1")
    m.addConstr(4*x0 + 6*x1 + 1*x2 <= 97, "deployment_weight_total_max2")
    m.addConstr(3*x1 + 14*x2 <= 186, "offensive_capability_recon_cbrn_max")
    m.addConstr(12*x0 + 3*x1 + 14*x2 <= 186, "offensive_capability_total_max")
    m.addConstr(9*x0 + 8*x1 <= 112, "fuel_demand_eng_recon_max")
    m.addConstr(8*x1 + 2*x2 <= 155, "fuel_demand_recon_cbrn_max")
    m.addConstr(9*x0 + 2*x2 <= 85, "fuel_demand_eng_cbrn_max")
    m.addConstr(9*x0 + 8*x1 + 2*x2 <= 85, "fuel_demand_total_max")
    m.addConstr(7*x1 + 4*x2 <= 40, "mobility_rating_recon_cbrn_max")
    m.addConstr(8*x0 + 7*x1 + 4*x2 <= 101, "mobility_rating_total_max1")
    m.addConstr(8*x0 + 7*x1 + 4*x2 <= 101, "mobility_rating_total_max2")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('engineer_platoons:', x0.x)
        print('reconnaissance_troops:', x1.x)
        print('CBRN_platoons:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
