
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="engineer_platoons", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="reconnaissance_troops", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(3*x0 + 7*x1 + 6*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*x0 + 6*x1 + x2 >= 40)
model.addConstr(12*x0 + 14*x2 >= 30)
model.addConstr(12*x0 + 3*x1 >= 28)
model.addConstr(12*x0 + 3*x1 + 14*x2 >= 55)
model.addConstr(4*x0 + x2 <= 86)
model.addConstr(4*x0 + 6*x1 <= 89)
model.addConstr(4*x0 + 6*x1 + x2 <= 97)
model.addConstr(3*x1 + 14*x2 <= 186)
model.addConstr(12*x0 + 3*x1 + 14*x2 <= 186)
model.addConstr(9*x0 + 8*x1 <= 112)
model.addConstr(8*x1 + 2*x2 <= 155)
model.addConstr(9*x0 + 2*x2 <= 85)
model.addConstr(9*x0 + 8*x1 + 2*x2 <= 85)
model.addConstr(7*x1 + 4*x2 <= 40)
model.addConstr(8*x0 + 7*x1 + 4*x2 <= 101)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Engineer platoons: ", x0.varValue)
    print("Reconnaissance troops: ", x1.varValue)
    print("CBRN platoons: ", x2.varValue)
else:
    print("The model is infeasible")
