
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein_bars")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="pickles")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bagged_salads")


    # Set objective function
    m.setObjective(3.85 * x0 + 4.96 * x1 + 2.41 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(18 * x0 + 12 * x1 >= 17, "c0")
    m.addConstr(18 * x0 + 16 * x2 >= 39, "c1")
    m.addConstr(12 * x1 + 16 * x2 >= 45, "c2")
    m.addConstr(18 * x0 + 12 * x1 + 16 * x2 >= 45, "c3")
    m.addConstr(20 * x1 + 11 * x2 >= 40, "c4")
    m.addConstr(7 * x0 + 11 * x2 >= 20, "c5")
    m.addConstr(7 * x0 + 20 * x1 + 11 * x2 >= 20, "c6")
    m.addConstr(-3 * x0 + 9 * x1 >= 0, "c7")
    m.addConstr(-4 * x1 + 6 * x2 >= 0, "c8")
    m.addConstr(-5 * x0 + 4 * x2 >= 0, "c9")
    m.addConstr(18 * x0 + 16 * x2 <= 87, "c10")
    m.addConstr(18 * x0 + 12 * x1 <= 56, "c11")
    m.addConstr(7 * x0 + 20 * x1 <= 61, "c12")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
