
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="protein_bars", lb=0)  # No upper bound given, assuming 0 is lower bound
    x1 = model.addVar(name="pickles", lb=0, integrality=1)  # Must be an integer
    x2 = model.addVar(name="bagged_salads", lb=0)  # No upper bound given, assuming 0 is lower bound

    # Define the objective function
    model.setObjective(3.85 * x0 + 4.96 * x1 + 2.41 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(18 * x0 + 12 * x1 >= 17)
    model.addConstr(18 * x0 + 16 * x2 >= 39)
    model.addConstr(12 * x1 + 16 * x2 >= 45)
    model.addConstr(18 * x0 + 12 * x1 + 16 * x2 >= 45)
    model.addConstr(20 * x1 + 11 * x2 >= 40)
    model.addConstr(7 * x0 + 11 * x2 >= 20)
    model.addConstr(7 * x0 + 20 * x1 + 11 * x2 >= 20)
    model.addConstr(-3 * x0 + 9 * x1 >= 0)
    model.addConstr(-4 * x1 + 6 * x2 >= 0)
    model.addConstr(-5 * x0 + 4 * x2 >= 0)
    model.addConstr(18 * x0 + 16 * x2 <= 87)
    model.addConstr(18 * x0 + 12 * x1 <= 56)
    model.addConstr(7 * x0 + 20 * x1 <= 61)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Protein bars: {x0.varValue}")
        print(f"Pickles: {x1.varValue}")
        print(f"Bagged salads: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
