
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Bill")
    x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="hours worked by Mary")


    # Set objective function
    model.setObjective(8.3*x0**2 + 5.41*x0*x1 + 3.95*x1**2 + 8.68*x0 + 2.57*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(8*x0 + 6*x1 >= 15, "c0")
    model.addConstr(17*x0 + 7*x1 >= 45, "c1")
    model.addConstr(3*x0 + 11*x1 >= 20, "c2")
    model.addConstr(5*x0 + 11*x1 >= 27, "c3")
    model.addConstr(5*x0**2 + 5*x1**2 >= 46, "c4")
    model.addConstr(8*x0**2 - 4*x1**2 >= 0, "c5")
    model.addConstr(8*x0 + 6*x1 <= 28, "c6")
    model.addConstr(17*x0 + 7*x1 <= 119, "c7")
    model.addConstr(3*x0 + 11*x1 <= 42, "c8")
    model.addConstr(5*x0 + 11*x1 <= 69, "c9")
    model.addConstr(5*x0 + 5*x1 <= 59, "c10")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

