
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bill", lb=0)  # Bill's hours
x1 = m.addVar(name="hours_worked_by_Mary", lb=0, vtype=gp.GRB.INTEGER)  # Mary's hours

# Define the objective function
m.setObjective(8.3*x0**2 + 5.41*x0*x1 + 3.95*x1**2 + 8.68*x0 + 2.57*x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x0 <= 46)
m.addConstr(6*x1 <= 46)
m.addConstr(17*x0 <= 144)
m.addConstr(7*x1 <= 144)
m.addConstr(3*x0 <= 71)
m.addConstr(11*x1 <= 71)
m.addConstr(5*x0 <= 91)
m.addConstr(11*x1 <= 91)
m.addConstr(5*x0 <= 92)
m.addConstr(5*x1 <= 92)
m.addConstr(8*x0 + 6*x1 >= 15)
m.addConstr(17*x0 + 7*x1 >= 45)
m.addConstr(3*x0 + 11*x1 >= 20)
m.addConstr(5*x0 + 11*x1 >= 27)
m.addConstr(5*x0**2 + 5*x1**2 >= 46)
m.addConstr(8*x0**2 - 4*x1**2 >= 0)
m.addConstr(8*x0 + 6*x1 <= 28)
m.addConstr(17*x0 + 7*x1 <= 119)
m.addConstr(3*x0 + 11*x1 <= 42)
m.addConstr(5*x0 + 11*x1 <= 69)
m.addConstr(5*x0 + 5*x1 <= 59)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bill: {x0.varValue}")
    print(f"Hours worked by Mary: {x1.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
