
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") #Bobby's hours
    x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="x1") #Dale's hours
    x2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="x2") #Jean's hours


    # Set objective function
    model.setObjective(7.57*x0**2 + 9.82*x0*x1 + 9.01*x0*x2 + 7.66*x1**2 + 1.58*x1*x2 + 9.11*x2**2 + 9.12*x0, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17*x0 + 20*x1 >= 36)
    model.addConstr(20*x1 + 11*x2 >= 28)
    model.addConstr(17*x0 + 20*x1 + 11*x2 >= 28)
    model.addConstr(2*x1 + 17*x2 >= 27)
    model.addConstr(18*x0 + 2*x1 + 17*x2 >= 27)
    model.addConstr(14*x0 + 16*x2 >= 10)
    model.addConstr(1*x1**2 + 16*x2**2 >= 13)
    model.addConstr(14*x0 + 1*x1 >= 10)
    model.addConstr(14*x0 + 1*x1 + 16*x2 >= 10)
    model.addConstr(6*x0 + 1*x2 >= 24)
    model.addConstr(6*x0**2 + 3*x1**2 >= 16)
    model.addConstr(6*x0 + 3*x1 + 1*x2 >= 29)
    model.addConstr(6*x0 + 3*x1 + 1*x2 >= 29)
    model.addConstr(8*x0**2 + 19*x2**2 >= 49)
    model.addConstr(8*x0 + 6*x1 >= 40)
    model.addConstr(8*x0 + 6*x1 + 19*x2 >= 40)
    model.addConstr(-5*x0 + 6*x1 >= 0)
    model.addConstr(18*x0**2 + 17*x2**2 <= 98)
    model.addConstr(2*x1 + 17*x2 <= 106)
    model.addConstr(18*x0 + 2*x1 <= 110)


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
