
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Bobby
    x1 = model.addVar(name="x1", lb=0, integrality=1)  # hours worked by Dale
    x2 = model.addVar(name="x2", lb=0, integrality=1)  # hours worked by Jean

    # Objective function
    model.setObjective(7.57 * x0**2 + 9.82 * x0 * x1 + 9.01 * x0 * x2 + 7.66 * x1**2 + 1.58 * x1 * x2 + 9.11 * x2**2 + 9.12 * x0, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17 * x0 <= 140)
    model.addConstr(18 * x0 <= 112)
    model.addConstr(14 * x0 <= 84)
    model.addConstr(6 * x0 <= 95)
    model.addConstr(8 * x0 <= 195)
    model.addConstr(20 * x1 <= 140)
    model.addConstr(2 * x1 <= 112)
    model.addConstr(x1 <= 84)
    model.addConstr(3 * x1 <= 95)
    model.addConstr(6 * x1 <= 195)
    model.addConstr(11 * x2 <= 140)
    model.addConstr(17 * x2 <= 112)
    model.addConstr(16 * x2 <= 84)
    model.addConstr(x2 <= 95)
    model.addConstr(19 * x2 <= 195)
    model.addConstr(17 * x0 + 20 * x1 >= 36)
    model.addConstr(20 * x1 + 11 * x2 >= 28)
    model.addConstr(17 * x0 + 20 * x1 + 11 * x2 >= 28)
    model.addConstr(2 * x1 + 17 * x2 >= 27)
    model.addConstr(18 * x0 + 2 * x1 + 17 * x2 >= 27)
    model.addConstr(14 * x0 + 16 * x2 >= 10)
    model.addConstr(x1**2 + 16 * x2**2 >= 13)
    model.addConstr(14 * x0 + x1 >= 10)
    model.addConstr(14 * x0 + x1 + 16 * x2 >= 10)
    model.addConstr(6 * x0 + x2 >= 24)
    model.addConstr(36 * x0**2 + 9 * x1**2 >= 16)
    model.addConstr(6 * x0 + 3 * x1 + x2 >= 29)
    model.addConstr(6 * x0 + 3 * x1 + x2 >= 29)
    model.addConstr(8 * x0**2 + 19 * x2**2 >= 49)
    model.addConstr(8 * x0 + 6 * x1 >= 40)
    model.addConstr(8 * x0 + 6 * x1 + 19 * x2 >= 40)
    model.addConstr(-5 * x0 + 6 * x1 >= 0)
    model.addConstr(324 * x0**2 + 289 * x2**2 <= 98)
    model.addConstr(2 * x1 + 17 * x2 <= 106)
    model.addConstr(18 * x0 + 2 * x1 <= 110)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bobby: {x0.varValue}")
        print(f"Hours worked by Dale: {x1.varValue}")
        print(f"Hours worked by Jean: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimization_problem()
