
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    hamburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hamburgers")
    fruit_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_salads")

    # Set objective function
    m.setObjective(5.28 * hamburgers + 7.67 * fruit_salads, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4 * hamburgers + 8 * fruit_salads >= 47, "fat_constraint1")
    m.addConstr(1 * hamburgers + 3 * fruit_salads >= 26, "sourness_constraint1")
    m.addConstr(10 * hamburgers - 5 * fruit_salads >= 0, "constraint3")
    m.addConstr(4 * hamburgers + 8 * fruit_salads <= 93, "fat_constraint2")
    m.addConstr(1 * hamburgers + 3 * fruit_salads <= 68, "sourness_constraint2")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('hamburgers:', hamburgers.x)
        print('fruit_salads:', fruit_salads.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
