
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")

# Set the objective function
m.setObjective(5.28*x1 + 7.67*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 8*x2 >= 47, "fat_content_min")
m.addConstr(x1 + 3*x2 >= 26, "sourness_index_min")
m.addConstr(10*x1 - 5*x2 >= 0, "hamburgers_vs_fruit_salads")
m.addConstr(4*x1 + 8*x2 <= 93, "fat_content_max")
m.addConstr(x1 + 3*x2 <= 68, "sourness_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"hamburgers: {x1.x}")
    print(f"fruit_salads: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
