
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    hamburgers = model.addVar(name="hamburgers", lb=0)
    fruit_salads = model.addVar(name="fruit_salads", lb=0)

    # Define the objective function
    model.setObjective(5.28 * hamburgers + 7.67 * fruit_salads, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4 * hamburgers + 8 * fruit_salads >= 47, name="fat_from_both")
    model.addConstr(4 * hamburgers >= 47, name="fat_from_hamburgers")
    model.addConstr(hamburgers + 3 * fruit_salads >= 26, name="sourness_index")
    model.addConstr(10 * hamburgers - 5 * fruit_salads >= 0, name="hamburgers_vs_fruit_salads")
    model.addConstr(4 * hamburgers + 8 * fruit_salads <= 93, name="max_fat_from_both")
    model.addConstr(hamburgers + 3 * fruit_salads <= 68, name="max_sourness_index")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hamburgers: {hamburgers.varValue}")
        print(f"Fruit Salads: {fruit_salads.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
