
from gurobipy import *

# Create a new model
model = Model("Resource_Allocation")

# Create variables
ringo = model.addVar(vtype=GRB.CONTINUOUS, name="ringo")
john = model.addVar(vtype=GRB.CONTINUOUS, name="john")
paul = model.addVar(vtype=GRB.CONTINUOUS, name="paul")
jean = model.addVar(vtype=GRB.CONTINUOUS, name="jean")
dale = model.addVar(vtype=GRB.CONTINUOUS, name="dale")
hank = model.addVar(vtype=GRB.CONTINUOUS, name="hank")


# Set objective
model.setObjective(10.0 * ringo + 4.86 * john + 9.97 * paul + 4.07 * jean + 2.91 * dale + 9.21 * hank, GRB.MAXIMIZE)

# Add constraints
model.addConstr(11 * ringo + 17 * paul >= 14)
model.addConstr(9 * jean + 9 * dale >= 22)
model.addConstr(11 * ringo + 8 * john >= 20)
model.addConstr(8 * john + 8 * hank >= 20)
model.addConstr(17 * paul + 8 * hank >= 30)
model.addConstr(17 * paul + 9 * dale >= 15)
model.addConstr(9 * jean + 8 * hank >= 16)
model.addConstr(8 * john + 9 * jean >= 11)
model.addConstr(8 * john + 17 * paul >= 24)
model.addConstr(9 * dale + 8 * hank >= 16)
model.addConstr(17 * paul + 9 * jean >= 26)
model.addConstr(1 * john + 15 * jean >= 52)
model.addConstr(20 * paul + 15 * jean >= 43)
model.addConstr(15 * jean + 11 * hank >= 68)
model.addConstr(15 * jean + 1 * dale >= 26)
model.addConstr(8 * ringo + 11 * hank >= 58)
model.addConstr(1 * dale + 11 * hank >= 51)
model.addConstr(1 * john + 20 * paul >= 52)
model.addConstr(20 * paul + 1 * dale >= 62)
model.addConstr(20 * paul + 1 * dale + 11 * hank >= 53)
model.addConstr(1 * john + 20 * paul + 1 * dale >= 53)
model.addConstr(1 * john + 20 * paul + 11 * hank >= 53)
model.addConstr(8 * ringo + 1 * john + 15 * jean >= 53)
model.addConstr(8 * ringo + 20 * paul + 15 * jean >= 53)
model.addConstr(8 * ringo + 1 * john + 11 * hank >= 53)
model.addConstr(20 * paul + 15 * jean + 1 * dale >= 53)
# ... (rest of the constraints)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('\nObjective Value: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

