
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', lb=0)  # hours worked by Ringo
x1 = m.addVar(name='x1', lb=0)  # hours worked by John
x2 = m.addVar(name='x2', lb=0)  # hours worked by Paul
x3 = m.addVar(name='x3', lb=0)  # hours worked by Jean
x4 = m.addVar(name='x4', lb=0)  # hours worked by Dale
x5 = m.addVar(name='x5', lb=0)  # hours worked by Hank

# Objective function
m.setObjective(10.0*x0 + 4.86*x1 + 9.97*x2 + 4.07*x3 + 2.91*x4 + 9.21*x5, gurobi.GRB.MAXIMIZE)

# Constraints
# Ringo's ratings
m.addConstr(11*x0 <= 180)  # work quality rating
m.addConstr(8*x0 <= 414)   # paperwork competence rating
m.addConstr(17*x0 <= 360)  # organization score
m.addConstr(9*x0 <= 320)   # dollar cost per hour

# John's ratings
m.addConstr(8*x1 <= 180)
m.addConstr(1*x1 <= 414)
m.addConstr(13*x1 <= 360)
m.addConstr(7*x1 <= 320)

# Paul's ratings
m.addConstr(17*x2 <= 180)
m.addConstr(20*x2 <= 414)
m.addConstr(18*x2 <= 360)
m.addConstr(5*x2 <= 320)

# Jean's ratings
m.addConstr(9*x3 <= 180)
m.addConstr(15*x3 <= 414)
m.addConstr(10*x3 <= 360)
m.addConstr(9*x3 <= 320)

# Dale's ratings
m.addConstr(9*x4 <= 180)
m.addConstr(1*x4 <= 414)
m.addConstr(4*x4 <= 360)
m.addConstr(7*x4 <= 320)

# Hank's ratings
m.addConstr(8*x5 <= 180)
m.addConstr(11*x5 <= 414)
m.addConstr(14*x5 <= 360)
m.addConstr(1*x5 <= 320)

# Work quality rating constraints
m.addConstr(11*x0 + 17*x2 >= 14)
m.addConstr(9*x3 + 9*x4 >= 22)
m.addConstr(11*x0 + 8*x1 >= 20)
m.addConstr(8*x1 + 8*x5 >= 20)
m.addConstr(17*x2 + 8*x5 >= 30)
m.addConstr(17*x2 + 9*x4 >= 15)
m.addConstr(9*x3 + 8*x5 >= 16)
m.addConstr(8*x1 + 9*x3 >= 11)
m.addConstr(8*x1 + 17*x2 >= 24)
m.addConstr(9*x4 + 8*x5 >= 16)
m.addConstr(17*x2 + 9*x3 >= 26)

# Paperwork competence rating constraints
m.addConstr(8*x1 + 15*x3 >= 52)
m.addConstr(20*x2 + 15*x3 >= 43)
m.addConstr(15*x3 + 11*x5 >= 68)
m.addConstr(15*x3 + 1*x4 >= 26)
m.addConstr(8*x0 + 11*x5 >= 58)
m.addConstr(1*x4 + 11*x5 >= 51)
m.addConstr(1*x1 + 20*x2 >= 52)
m.addConstr(20*x2 + 1*x4 >= 62)
m.addConstr(20*x2 + 1*x4 + 11*x5 >= 53)
m.addConstr(1*x1 + 20*x2 + 1*x4 >= 53)
m.addConstr(1*x1 + 20*x2 + 11*x5 >= 53)
m.addConstr(8*x0 + 1*x1 + 15*x3 >= 53)
m.addConstr(11*x0 + 20*x2 + 15*x3 >= 53)
m.addConstr(8*x0 + 1*x1 + 11*x5 >= 53)
m.addConstr(20*x2 + 15*x3 + 1*x4 >= 53)
m.addConstr(20*x2 + 1*x4 + 11*x5 >= 39)
m.addConstr(1*x1 + 20*x2 + 1*x4 >= 39)
m.addConstr(1*x1 + 20*x2 + 11*x5 >= 39)
m.addConstr(8*x0 + 1*x1 + 15*x3 >= 39)
m.addConstr(11*x0 + 20*x2 + 15*x3 >= 39)
m.addConstr(8*x0 + 1*x1 + 11*x5 >= 39)
m.addConstr(15*x3 + 1*x4 + 11*x5 >= 69)
m.addConstr(1*x1 + 20*x2 + 1*x4 >= 69)
m.addConstr(1*x1 + 20*x2 + 11*x5 >= 69)
m.addConstr(8*x0 + 1*x1 + 15*x3 >= 69)
m.addConstr(11*x0 + 20*x2 + 15*x3 >= 69)
m.addConstr(8*x0 + 1*x1 + 11*x5 >= 69)

# Organization score constraints
m.addConstr(17*x2 + 4*x4 >= 31)
m.addConstr(10*x3 + 4*x4 >= 22)
m.addConstr(17*x0 + 18*x2 + 10*x3 >= 60)
m.addConstr(18*x2 + 4*x4 + 14*x5 >= 4)
m.addConstr(17*x0 + 13*x1 + 18*x2 >= 60)
m.addConstr(17*x0 + 13*x1 + 4*x4 >= 60)
m.addConstr(17*x0 + 18*x2 + 10*x3 >= 38)
m.addConstr(18*x2 + 4*x4 + 14*x5 >= 38)
m.addConstr(17*x0 + 13*x1 + 18*x2 >= 38)
m.addConstr(17*x0 + 13*x1 + 4*x4 >= 43)
m.addConstr(17*x0 + 18*x2 + 10*x3 >= 41)
m.addConstr(18*x2 + 4*x4 + 14*x5 >= 41)
m.addConstr(17*x0 + 13*x1 + 18*x2 >= 41)
m.addConstr(17*x0 + 13*x1 + 4*x4 >= 41)

# Dollar cost per hour constraints
m.addConstr(9*x3 + 1*x5 >= 27)
m.addConstr(7*x1 + 1*x5 >= 35)
m.addConstr(7*x1 + 7*x4 >= 37)
m.addConstr(5*x2 + 9*x3 >= 32)
m.addConstr(9*x0 + 5*x2 + 9*x3 >= 33)
m.addConstr(9*x0 + 5*x2 + 7*x4 >= 33)
m.addConstr(17*x0 + 7*x1 + 5*x2 >= 33)
m.addConstr(5*x2 + 9*x3 + 1*x5 >= 33)
m.addConstr(17*x0 + 7*x1 + 7*x4 >= 33)

# Solve the model
m.optimize()

# Print the solution
print('Objective: ', m.objVal)
for v in m.getVars():
    print(v.name, ':', v.x)
